unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMGauge, MMCstDlg, StdCtrls, MMHook, MMDesign, MMWave, MMDSPObj,
  MMTrigg, MMAudio, MMSystem;

type
  TForm1 = class(TForm)
    AudioFile: TMMAudioFile;
    Trigger: TMMTrigger;
    WaveFile: TMMWaveFile;
    MMDesigner1: TMMDesigner;
    btnConvert: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TMMWaveSaveDialog;
    Gauge: TMMGauge;
    procedure btnConvertClick(Sender: TObject);
    procedure TriggerStart(Sender: TObject);
    procedure TriggerStop(Sender: TObject);
    procedure TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ This demo converts a mp3 file to a PCM wave file                             }

{------------------------------------------------------------------------------}
procedure TForm1.btnConvertClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      AudioFile.FileName := OpenDialog.FileName;
      if SaveDialog.Execute then
      begin
         WaveFile.Wave.FileName := SaveDialog.FileName;
         Trigger.Start;
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStart(Sender: TObject);
begin
   btnConvert.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStop(Sender: TObject);
begin
   // close the trigger (and all other components)
   Trigger.Close;
   btnConvert.Enabled := True;
   Gauge.Progress     := 0;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   Gauge.Progress := Round((AudioFile.Position*100)/AudioFile.FileLength);
end;

end.
